@extends('user')
@section('content')
    @include('partials.breadcrumb')

    <div class="container">
        <div class="card mt-4 mb-5">
            <div class="card-header bg-info text-white">
                <span class="float-left"> {{__($page_title)}}</span>
                <span class="float-right"><a href="{{route('home')}}" class="btn btn-warning btn-sm"> @lang('View All') </a></span>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-5">
                        <span class="float-left"><b> @lang('Exchange ID') </b></span>
                        <span class="float-right">{{ $exchange->trx }}</span>
                    </div>
                    <div class="col-md-2">

                    </div>
                    <div class="col-md-5">
                        <span class="float-left"><b> @lang('Status') </b></span>
                        <span class="float-right">
                        @if ($exchange->status == '2' )
                               <span class="badge badge-success"> @lang('Completed')</span>
                            @elseif ($exchange->status == '-1' )
                                <span class="badge badge-danger"> @lang('Cancelled')</span>
                            @elseif ($exchange->status == '-2')
                                <span class="badge badge-primary"> @lang('Refunded')</span>
                            @else
                                <span class="badge badge-warning"> @lang('Pending')</span>
                            @endif
                    </span>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-5">
                        <span class="float-left"><b> @lang('Customer Email') </b></span>
                        <span class="float-right">{{ $exchange->customer_email }}</span>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-5">
                        <span class="float-left"><b> @lang('Send Currency') </b></span>
                        <span class="float-right">{{ $exchange->send_method->name }}</span>
                    </div>
                    <div class="col-md-2">

                    </div>
                    <div class="col-md-5">
                        <span class="float-left"><b> @lang('Receive Currency') </b></span>
                        <span class="float-right">{{ $exchange->receive_method->name }}</span>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-5">
                        <span class="float-left"><b> @lang('Send Amount') </b></span>
                        <span class="float-right">{{ $exchange->send_amount }}</span>
                    </div>
                    <div class="col-md-2">

                    </div>
                    <div class="col-md-5">
                        <span class="float-left"><b> @lang('Receive Amount') </b></span>
                        <span class="float-right">{{ $exchange->receive_amount }}</span>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-5">
                        <span class="float-left"><b>{{ $exchange->send_method->name }}  @lang('Transaction No.') </b></span>
                        <span class="float-right">{{ $exchange->transaction_number }}</span>
                    </div>
                    <div class="col-md-2">

                    </div>
                    <div class="col-md-5">
                        <span class="float-left"><b>{{ $exchange->receive_method->name }} @lang('Transaction No.')</b></span>
                        <span class="float-right">{{ $exchange->admin_transaction_number }}</span>
                    </div>
                </div>

                @if ($exchange->status == '-1' )
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h4> @lang('Reason Of Cancellation') </h4>
                            <p>{{ $exchange->cancel_reason }}</p>
                        </div>
                    </div>
                @elseif ($exchange->status == '-2' )
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h4> @lang('Reason Of Refund') </h4>
                            <p>{{ $exchange->refund_reason }}</p>
                        </div>
                    </div>
                @else

                @endif
            </div>
        </div>
    </div>

@endsection
